import { addMemory, getMemory, getAllMemories, deleteMemory } from './db.mjs';

export function remember(key, content, category = 'general') {
  addMemory(key, content, category);
}

export function recall(key) {
  const mem = getMemory(key);
  return mem ? mem.content : null;
}

export function recallAll(category) {
  return getAllMemories(category);
}

export function forget(key) {
  deleteMemory(key);
}

/**
 * Build a context string from all memories for use in Claude prompts.
 */
export function getContextForPrompt() {
  const memories = getAllMemories();
  if (!memories.length) return '';

  const grouped = {};
  for (const m of memories) {
    const cat = m.category || 'general';
    if (!grouped[cat]) grouped[cat] = [];
    grouped[cat].push(m);
  }

  let context = '## My Memories\n\n';
  for (const [category, items] of Object.entries(grouped)) {
    context += `### ${category}\n`;
    for (const item of items) {
      context += `- **${item.key}**: ${item.content}\n`;
    }
    context += '\n';
  }
  return context;
}
