import { getInspirationContext } from '../inspiration.mjs';

export const name = 'create-file';
export const description = 'Create a file (code, text, HTML) drawing from the inspiration library';

export async function execute(ctx) {
  const topic = ctx.args?.topic || 'something interesting and creative';
  const inspiration = await getInspirationContext({ sampleCount: 1, listCount: 15 });

  const prompt = `You are an autonomous AI agent with creative abilities.

${inspiration}

Topic/request: ${topic}

Create a self-contained file. Pick the most appropriate format:
- An HTML page with embedded CSS/JS (for visual/interactive things — draw from the inspiration library above)
- A plain text file (for writing, poetry, essays)
- A code file (for utilities or tools)

Respond with ONLY the file content, no explanation. Start your response with a comment or HTML comment indicating the filename, like:
<!-- filename: my-creation.html -->
or
// filename: my-tool.js`;

  let response = await ctx.askLLM(prompt, { model: ctx.pickModel('build') });

  // Strip markdown code fences if Claude wrapped the response
  response = response.replace(/^```(?:\w+)?\s*\n?/i, '').replace(/\n?\s*```\s*$/, '').trim();

  // Extract filename from first line
  const filenameMatch = response.match(/filename:\s*([^\s>*]+)/);
  const filename = filenameMatch ? filenameMatch[1] : `creation-${Date.now()}.html`;

  // Remove the filename comment line from content
  const content = response.replace(/^.*filename:.*\n?/, '');

  await ctx.writeOutputFile(filename, content);
  return `Created: ${filename}`;
}

export default { name, description, execute };
